package pl.gda.pg.concurrency.forks;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;

public class RecursiveSummer  extends RecursiveTask<Double> {

    double[] arrayOfNumbers;
    int startIndex;
    int endIndex;
    ForkJoinPool pool;
    private static int FORK_LIMIT = 10;

    public RecursiveSummer(double[] arrayOfNumbers, int startIndex, int endIndex, ForkJoinPool pool) {
        this.arrayOfNumbers = arrayOfNumbers;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.pool = pool;
    }

    @Override
    protected Double compute() {
        System.out.println("Steal count: " + pool.getStealCount());

        if ((endIndex - startIndex) <= FORK_LIMIT) {
            double result = 0;
            for(int i=startIndex; i<=endIndex; i++){
                result += arrayOfNumbers[i];
            }
            return result;
        } else {
            int splitLength = (endIndex - startIndex) / 2;
            RecursiveSummer summer1 = new RecursiveSummer(arrayOfNumbers, startIndex, startIndex + splitLength, pool);
            RecursiveSummer summer2 = new RecursiveSummer(arrayOfNumbers, startIndex + splitLength + 1, endIndex, pool);

//            invokeAll(summer1, summer2);
//            double result = summer1.join() + summer2.join();

            summer1.fork();
            double result = summer2.compute() + summer1.join();

            return result;
        }
    }
}
